import sys
sys.setrecursionlimit(100000)

class Tree:
    left: "Tree" = None
    right: "Tree" = None

    def __init__(self, left=None, right=None):
        assert left is None or isinstance(left, Tree)
        assert right is None or isinstance(right, Tree)
        assert not ((left is None) ^ (right is None))
        self.left = left
        self.right = right

    @classmethod
    def leaf(cls) -> "Tree":
        return Tree()

    @classmethod
    def branch(cls, left: "Tree", right: "Tree") -> "Tree":
        return Tree(left, right)

    def is_leaf(self) -> bool:
        return self.left is None and self.right is None

    def is_branch(self) -> bool:
        return self.left is not None and self.right is not None

    def can_apply_assoc(self) -> bool:
        return self.is_branch() and self.right.is_branch()

    def is_left_balanced(self) -> bool:
        return self.is_leaf() or (self.right.is_leaf() and self.left.is_left_balanced())

    def apply_assoc(self) -> None:
        assert self.can_apply_assoc()
        old_left = self.left
        self.left = Tree.branch(old_left, self.right.left)
        self.right = self.right.right

    def pprint(self):
        if self.is_leaf():
            return '1'
        else:
            return f"x {self.left.pprint()} {self.right.pprint()}"

def input_helper(parts: list) -> Tree:
    assert parts[0] == 'x'
    parts.pop(0)

    if parts[0] == 'x':
        left = input_helper(parts)
    else:
        parts.pop(0)
        left = Tree.leaf()

    if parts[0] == 'x':
        right = input_helper(parts)
    else:
        parts.pop(0)
        right = Tree.leaf()

    return Tree.branch(left, right)


def read_input() -> Tree:
    parts = input().split()
    return input_helper(parts)

def solve(tree: Tree) -> int:
    current_tree = tree
    num_steps = 0
    while not current_tree.is_left_balanced():
        if current_tree.can_apply_assoc():
            num_steps += 1
            current_tree.apply_assoc()
            continue
        else:
            current_tree = current_tree.left
    return num_steps

if __name__ == '__main__':
    tree = read_input()
    print(solve(tree))